// redirects.js
(function() {
  const now = new Date();
  const month = now.getMonth(); // 0 = Jan, 11 = Dec
  const day = now.getDate();
  const url = window.location.href;

  const isHalloween = (month === 9 && day >= 1 && day <= 31);
  const isWinter = (month === 10 && day >= 1) || (month === 0 && day <= 6);

  const mainURL = "https://ezbakery.neocities.org/";
  const halloweenURL = "https://ezbakery.neocities.org/halloween/halloween.html";
  const winterURL = "https://ezbakery.neocities.org/holiday/Winter";

  // --- On main page ---
  if (url === mainURL || url === mainURL + "index.html") {
    if (isHalloween) {
      window.location.href = halloweenURL;
      return;
    }
    if (isWinter) {
      window.location.href = winterURL;
      return;
    }
    return; // otherwise stay on /
  }

  // --- On Halloween page ---
  if (url.includes("/halloween/") && !isHalloween) {
    window.location.href = mainURL;
    return;
  }

  // --- On Winter page ---
  if (url.includes("/holiday/") && !isWinter) {
    window.location.href = mainURL;
    return;
  }
})();
